<?php

declare(strict_types=1);
namespace Drupal\symfony_form\Twig\RuntimeLoader;

use Drupal\Core\DependencyInjection\ContainerBuilder;
use Symfony\Bridge\Twig\Form\TwigRendererEngine;
use Symfony\Component\DependencyInjection\Definition;
use Symfony\Component\DependencyInjection\Reference;
use Symfony\Component\Form\FormRenderer;
use Symfony\Component\Security\Csrf\CsrfTokenManager;
use Twig\Environment;
use Twig\RuntimeLoader\RuntimeLoaderInterface;

final class FormRuntimeLoader implements RuntimeLoaderInterface {

  public static function addToContainer(ContainerBuilder $container): void {
    // Add our definition.
    $container->addDefinitions([
      self::class => (new Definition(self::class, [new Reference('twig')])),
    ]);
    // Add as twig runtime loader.
    $container->getDefinition('twig')
      ->addMethodCall('addRuntimeLoader', [new Reference(self::class)]);
  }

  public function __construct(
    private readonly Environment $twigEnvironment,
  ) {}

  public function load(string $class) {
    if ($class === FormRenderer::class) {
      return new FormRenderer(
        engine: new TwigRendererEngine(
          defaultThemes: [],
          environment: $this->twigEnvironment,
        ),
        csrfTokenManager: new CsrfTokenManager(),
      );
    }
    return NULL;
  }

}
