<?php

declare(strict_types=1);
namespace Drupal\symfony_form\Twig\Sandbox;

use Twig\Sandbox\SecurityPolicyInterface;

final class SandboxPolicyDecorator implements SecurityPolicyInterface {

  public function __construct(
    private readonly SecurityPolicyInterface $decorated,
    private readonly array $allowedMethods,
    private readonly array $allowedProperties,
  ) {}

  public function checkSecurity($tags, $filters, $functions): void {
    $this->decorated->checkSecurity($tags, $filters, $functions);
  }

  public function checkMethodAllowed($obj, $method): void {
    if (in_array(get_class($obj) . '::' . $method, $this->allowedMethods)) {
      return;
    }
    $this->decorated->checkMethodAllowed($obj, $method);
  }

  public function checkPropertyAllowed($obj, $property): void {
    if (in_array(get_class($obj) . '::' . $property, $this->allowedProperties)) {
      return;
    }
    $this->decorated->checkPropertyAllowed($obj, $property);
  }

}
