<?php

declare(strict_types=1);
namespace Drupal\symfony_form\Twig\Sandbox;

use Drupal\Core\Template\TwigEnvironment;
use Twig\Extension\ExtensionInterface;
use Twig\Extension\SandboxExtension;

final class TwigConfiguratorExtensionFactory {

  public function __construct(
    private readonly TwigEnvironment $twig,
  ) {}

  /**
   * Add a dummy twig extension to configure twig before usage.
   */
  public function createExtension(): ExtensionInterface {
    $this->decorateTwigSecurityPolicy();
    return new DummyExtension();
  }

  public function decorateTwigSecurityPolicy(): void {
    /** @var SandboxExtension $sandboxExtension */
    $sandboxExtension = $this->twig->getExtension(SandboxExtension::class);
    $policy = $sandboxExtension->getSecurityPolicy();
    $decoratedPolicy = new SandboxPolicyDecorator(
      decorated: $policy,
      allowedMethods: [
        'Symfony\Component\Form\FormView::setMethodRendered',
      ],
      allowedProperties: [],
    );
    $sandboxExtension->setSecurityPolicy($decoratedPolicy);
  }

}
