<?php

declare(strict_types=1);
namespace Drupal\symfony_form\Twig\TemplateLoader;

use Composer\InstalledVersions;
use Twig\Loader\LoaderInterface;
use Twig\Source;

final class FormTemplateLoader implements LoaderInterface {

  const string NamePrefix = 'symfony_form.theme:';

  private ?string $cachedBasePath = NULL;

  public function exists(string $name) {
    return !!$this->getFilePath($name);
  }

  public function getSourceContext(string $name): Source {
    $path = $this->getFilePath($name);
    if ($path) {
      return new Source(file_get_contents($path), $name, $path);
    }
    else {
      return new Source('', $name, '');
    }
  }

  public function getCacheKey(string $name): string {
    return $name;
  }

  public function isFresh(string $name, int $time): bool {
    $path = $this->getFilePath($name);
    return filemtime($path) < $time;
  }

  private function getFilePath(string $name): ?string {
    if (str_starts_with($name, self::NamePrefix)) {
      $baseName = substr($name, strlen(self::NamePrefix));
      $filePath = "{$this->getBasePath()}/$baseName.html.twig";
      if (file_exists($filePath)) {
        return $filePath;
      }
    }
    return NULL;
  }

  private function getBasePath(): string {
    return $this->cachedBasePath
      ?? (
        $this->cachedBasePath = InstalledVersions::getInstallPath('symfony/twig-bridge')
          . '/Resources/views/Form'
      );
  }

}
