<?php

namespace Drupal\symfony_mailer_addons\Plugin\EmailAdjuster;

use Drupal\Core\Form\FormStateInterface;
use Drupal\symfony_mailer\EmailInterface;
use Drupal\symfony_mailer\Processor\EmailAdjusterBase;

/**
 * Defines the Email Template Suggestion Adjuster.
 *
 * @EmailAdjuster(
 *   id = "email_template_suggestion",
 *   label = @Translation("Email Template Suggestion Adjuster"),
 *   description = @Translation("Allows to provide custom suggestions for email template from UI."),
 * )
 */
class EmailTemplateSuggestionAdjuster extends EmailAdjusterBase {

  /**
   * {@inheritdoc}
   */
  public function settingsForm(array $form, FormStateInterface $form_state) {
    $form['suggestion'] = [
      '#title' => $this->t('Email template suggestion'),
      '#type' => 'textfield',
      '#default_value' => $this->configuration['suggestion'] ?? '',
      '#description' => $this->t('Provide a custom suggestion for the email template.<br> Example: <code>email__@value</code>.', [
        '@value' => $this->configuration['suggestion'] ?? '{your_value}',
      ]),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function build(EmailInterface $email) {
    $suggestion = $this->configuration['suggestion'] ?? NULL;

    if ($suggestion) {
      $email->setVariable('suggestion', $suggestion);
    }
  }

}
