<?php

namespace Drupal\synhelper\Hook;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;

/**
 * Commerce CheckoutFlow Alter.
 */
class FormCommerceCheckoutFlowMultistepDefaultAlter {

  /**
   * Hook preprocess.
   */
  public static function hook(&$form, $form_state, $form_id) {
    $config = \Drupal::config('synhelper.settings');
    // Step 1 Order Information.
    if ($form['#step_id'] == 'order_information') {
      // FZ-152 checkbox.
      if ($config->get('fz152') && strpos($form_id, 'commerce_checkout_flow_multistep_default') === 0) {
        $url = $config->get('link') ? Url::fromUserInput($config->get('link')) : Url::fromUserInput('/policy');
        $lang = \Drupal::languageManager()->getCurrentLanguage()->getId();
        $text = [
          'title' => t("I consent to the processing of personal data"),
          'description' => t(
            "<a href='@href' target='_blank'>Cookie & Privacy Policy for Website</a>",
            ['@href' => $url->toString()]
          ),
        ];
        if ($lang == 'ru') {
          $agreement_text = $config->get('agreement-text') ? $config->get('agreement-text') : 'Нажимая кнопку, я даю согласие на&nbsp;обработку {ссылка}';
          $link_text = $config->get('link-text') ? $config->get('link-text') : 'персональных данных';
          $description = '';
          if (strpos($agreement_text, '{ссылка}') !== FALSE) {
            $agreement_text = str_replace('{ссылка}', "<a href=" . $url->toString() . " target='_blank'>" . $link_text . "</a>", $agreement_text);
          } else {
            $description = "<a href=" . $url->toString() . " target='_blank'>" . $link_text . "</a>";
          }
          $text = [
            'title' => $agreement_text,
            'description' => $description,
          ];
        }
        $form['#validate'][] = [self::class, 'CustomContactFormValidate'];
        $form['fz152_agreement'] = [
          '#type' => 'checkbox',
          '#title' => $text['title'],
          '#default_value' => FALSE,
          '#required' => FALSE,
          '#attributes' => [
            'class' => ['form-item--fz-152-checkbox'],
          ],
          '#wrapper_attributes' => [
            'class' => 'form-item--fz-152',
          ],
          '#label_attributes' => [
            'class' => 'form-item--fz-152-label',
          ],
          '#description' => [
            '#type' => 'markup',
            '#prefix' => '<div class="form-item--fz-152-desctiprion">',
            '#suffix' => '</div>',
            '#markup' => $text['description'],
          ],
          '#weight' => 99,
        ];
      };
    }
  }

  /**
   * Кастомная валидация формы.
   */
  public static function CustomContactFormValidate(array &$form, FormStateInterface $form_state) {
    if ($form_state->isRebuilding()) {
      return;
    }

    $triggering_element = $form_state->getTriggeringElement();
    if (!empty($triggering_element['#name'])) {
      $button_name = $triggering_element['#name'];
      if (
        strpos($button_name, '_upload_button') !== FALSE ||
        strpos($button_name, '_remove_button') !== FALSE
      ) {
        return;
      }
    }

    $values = $form_state->getValues();
    $agreement = isset($values['fz152_agreement']) ? $values['fz152_agreement'] : 0;

    if (!$agreement) {
      $form_state->setErrorByName('fz152_agreement', t('Вы должны согласиться с условиями политики конфиденциальности.'));
    }
  }
}
