<?php

namespace Drupal\synhelper\Hook;

use Drupal\Core\Render\Markup;
use Drupal\Core\Url;

/**
 * PreprocessHtml.
 */
class Requirements {

  /**
   * Hook.
   */
  public static function hook($phase) {
    $requirements = [];
    if ($phase === 'runtime') {
      $url = Url::fromUserInput('/admin/config/synapse/synhelper')->toString();
      $message = t('<b>The site is indexed by search engines.</b> <a href="@href">Disable indexation</a>!', ['@href' => $url]);
      $requirements = [
        'synhelper_index' => [
          'title' => t('Synhelper: OK'),
          'value' => Markup::create($message),
          'severity' => REQUIREMENT_WARNING,
        ],
      ];
      // No-index:
      $config = \Drupal::config('synhelper.settings');
      if ($config->get('no-index')) {
        $message = t('<b>NO-INDEX Attention!</b> The site is not indexed by search engines. <a href="@href">Enable indexation</a>!', ['@href' => $url]);
        $requirements = [
          'synhelper_index' => [
            'title' => t('Synhelper: NO-INDEX'),
            'value' => Markup::create($message),
            'severity' => REQUIREMENT_ERROR,
          ],
        ];
      }
    }
    return $requirements;
  }

}
