<?php

namespace Drupal\synhelper\Utility;

/**
 * @file
 * Contains \Drupal\synhelper\Utility\Logo.
 */

/**
 * Syn svg Logo.
 */
class Logo {

  /**
   * Svg.
   */
  public static function renderable($color = '#2b2a29') {
    return [
      '#markup' => self::svg($color),
      '#allowed_tags' => ['style', 'svg', 'g', 'path'],
    ];
  }

  /**
   * Svg.
   */
  public static function svg($color = '#2b2a29') {
    $svg = "
    <svg width='100%' height='auto' viewBox='0 0 138 58' version='1.1' xmlns='http://www.w3.org/2000/svg' >
    <g id='logo'>
      <path id='path5' class='path' transform='scale(1.15,1.15)'
        stroke='{$color}' stroke-width='0.3472' fill='none'
        d='m 22.62,41.42 c 1.83,0 3.69,0.22 5.5,0.45 0.46,0.1 0.93,0.18 1.4,
  	    0.19 2.7,0.1 1.72,-3.52 2.84,-5.03 0.17,-0.22 0.38,-0.4 0.63,-0.53
  	    0.1,0 0.95,-0.25 0.96,-0.29 0.28,-1.19 -0.52,-1.32 -0.35,-2.4 0.99,
  	    0.1 1.8,-0.1 1.7,-1.31 0,0 -0.43,-1.44 0,-2.12 1.24,-0.6 2.65,-1.03
  	    2.77,-2.74 -1.02,-1.96 -2.3,-3.66 -3.11,-5.83 0.78,-2.35 0.84,-5.04
  	    0.32,-7.44 C 33.4,5.558 25.03,-1.048 15.53,0.3992 11.01,1.089 6.067,
  	    3.278 4.062,7.598 3.43,8.961 3.084,10.44 2.866,11.91 c -0.238,1.62
  	   -0.54,3.47 -0.425,5.1 0.12,1.67 1.086,5.45 0.924,7.12 -0.301,3.11
  	   -2.989,3.94 -3.1562,7.1 -0.1782,3.39 2.2902,6.2 4.5142,8.52 2.138,
  	   2.23 5.006,4.73 8.287,4.81 3.54,0.1 6.1,-3.11 9.61,-3.14 z' />
      <path id='path7' transform='scale(1.15,1.15)'
        fill='none' stroke='{$color}' stroke-width='0.1736'
         d='m 19.44,37.91 c 1.17,0 2.36,0.14 3.52,0.29 0.3,0 0.6,0.11 0.9,
  	   0.12 1.72,0 1.1,-2.28 1.81,-3.25 0.11,-0.15 0.25,-0.26 0.41,-0.34
  	   0.1,0 0.6,-0.17 0.61,-0.19 0.18,-0.77 -0.33,-0.85 -0.22,-1.55 0.63,
  	   0 1.15,-0.1 1.09,-0.85 0,0 -0.28,-0.93 0,-1.37 0.79,-0.39 1.7,-0.67
  	   1.77,-1.77 -0.65,-1.27 -1.48,-2.37 -1.99,-3.77 0.5,-1.52 0.54,-3.27
  	   0.2,-4.82 -1.22,-5.69 -6.58,-9.96 -12.66,-9.03 -2.9,0.45 -6.059,
  	   1.86 -7.344,4.66 -0.405,0.88 -0.627,1.83 -0.766,2.79 -0.153,1.04
  	   -0.345,2.24 -0.271,3.3 0.08,1.07 0.695,3.51 0.591,4.6 -0.192,2.01
  	   -1.915,2.54 -2.02,4.59 -0.116,2.19 1.465,4.01 2.89,5.51 1.367,1.44
  	   3.2,3.06 5.3,3.11 2.27,0.1 3.91,-2.01 6.16,-2.03 z'/>
      <path id='path9' transform='scale(1.15,1.15)'
        fill='none' stroke='{$color}' stroke-width='0.1736'
         d='m 18.41,31.48 c 1.17,0 2.36,0.15 3.52,0.3 0.3,0 0.6,0.11 0.9,
  	   0.12 1.72,0 1.1,-2.28 1.82,-3.26 0.1,-0.14 0.24,-0.26 0.4,-0.34
  	   0.1,0 0.61,-0.16 0.61,-0.19 0.18,-0.77 -0.33,-0.85 -0.22,-1.55
  	   0.63,0 1.15,-0.1 1.09,-0.84 0,0 -0.28,-0.94 0,-1.38 0.79,-0.39
  	   1.7,-0.66 1.77,-1.77 -0.65,-1.27 -1.47,-2.37 -1.99,-3.77 0.5,
  	   -1.52 0.54,-3.26 0.2,-4.81 C 25.31,8.291 19.95,4.02 13.87,4.955
  	   10.98,5.402 7.812,6.819 6.528,9.612 6.123,10.49 5.901,11.45
  	   5.762,12.4 5.609,13.45 5.417,14.64 5.49,15.7 c 0.08,1.08 0.696,
  	   3.52 0.592,4.6 -0.192,2.01 -1.914,2.55 -2.022,4.59 -0.114,2.2
  	   1.467,4.01 2.891,5.51 1.367,1.44 3.209,3.06 5.309,3.11 2.26,0.1
  	   3.9,-2.01 6.15,-2.03 z'/>
      <path id='path11' transform='scale(1.15,1.15)'
        fill='none' stroke='{$color}' stroke-width='0.2604'
         d='m 24.4,30.97 c 1.17,0 2.36,0.14 3.52,0.29 0.3,0 0.6,0.11 0.9,
  	   0.12 1.72,0 1.1,-2.27 1.82,-3.25 0.1,-0.15 0.24,-0.26 0.4,-0.34
  	   0.1,0 0.61,-0.17 0.61,-0.19 0.18,-0.77 -0.33,-0.85 -0.22,-1.55
  	   0.64,0 1.15,-0.1 1.09,-0.85 0,0 -0.28,-0.93 0,-1.37 0.79,-0.39
  	   1.7,-0.67 1.77,-1.77 -0.65,-1.27 -1.47,-2.37 -1.99,-3.77 0.5,
  	   -1.52 0.54,-3.27 0.2,-4.82 C 31.3,7.777 25.94,3.507 19.86,4.442
  	   16.97,4.887 13.8,6.304 12.52,9.098 c -0.41,0.88 -0.63,1.832 -0.77,
  	   2.792 -0.15,1.04 -0.34,2.24 -0.27,3.3 0.1,1.08 0.7,3.51 0.59,4.6
  	   -0.19,2.01 -1.91,2.54 -2.02,4.59 -0.114,2.19 1.47,4.01 2.89,5.51
  	   1.37,1.44 3.21,3.06 5.31,3.11 2.26,0 3.9,-2.01 6.15,-2.03 z'/>
      <path id='path13' transform='scale(1.15,1.15)'
        fill='none' stroke='{$color}' stroke-width='0.2604'
         d='m 24.5,39.45 c 1.17,0 2.36,0.14 3.52,0.29 0.3,0 0.59,0.12 0.9,
  	   0.12 1.72,0 1.1,-2.28 1.82,-3.25 0.1,-0.14 0.24,-0.26 0.4,-0.34
  	   0.1,0 0.6,-0.17 0.61,-0.19 0.18,-0.77 -0.33,-0.85 -0.22,-1.55 0.63,
  	   0 1.15,-0.1 1.09,-0.85 0,0 -0.28,-0.93 0,-1.37 0.79,-0.39 1.69,-0.67
  	   1.77,-1.77 -0.65,-1.27 -1.47,-2.37 -1.99,-3.77 0.5,-1.52 0.54,-3.26
  	   0.2,-4.82 -1.22,-5.69 -6.58,-9.96 -12.66,-9.03 -2.9,0.45 -6.06,1.86
  	   -7.34,4.66 -0.41,0.88 -0.63,1.83 -0.77,2.79 -0.15,1.05 -0.34,2.24
  	   -0.27,3.3 0.1,1.08 0.69,3.52 0.59,4.6 -0.19,2.01 -1.91,2.54 -2.02,
  	   4.59 -0.11,2.19 1.47,4.01 2.89,5.51 1.37,1.44 3.2,3.06 5.31,3.11
  	   2.26,0.1 3.9,-2.01 6.15,-2.03 z'/>
      <path id='path15' transform='scale(1.15,1.15)'
        fill='{$color}' stroke='none' stroke-width='0.8696'
         d='m 110.5,33.12 c -1.8,0.76 -2.6,2.29 -2.6,4.24 l 0,4.85 c 0,1.91
  	   0.7,3.55 2.6,4.32 2.3,0.98 6.4,0.31 8.4,-1.29 l -1.5,-2.21 c -1.4,
  	   0.98 -6.6,2.18 -6.6,-0.82 l 0,-4.85 c 0,-2.94 5.1,-1.58 6.6,-0.77
  	   l 1.5,-2.23 c -2,-1.5 -6.1,-2.21 -8.4,-1.24 z'/>
      <path id='path17' transform='scale(1.15,1.15)'
        fill='{$color}' stroke='none' stroke-width='0.8696'
         d='m 53.14,43.03 1.5,2.21 c -1.96,1.6 -6.06,2.27 -8.36,1.29 -1.89,
  	   -0.77 -2.57,-2.41 -2.57,-4.32 l 0,-4.85 c 0,-1.95 0.72,-3.48 2.57,
  	   -4.24 2.29,-0.97 6.37,-0.26 8.36,1.24 l -1.5,2.23 c -1.44,-0.81
  	   -6.61,-2.17 -6.61,0.77 l 0,4.85 c 0,3 5.21,1.8 6.61,0.82 z'/>
      <path id='path19' transform='scale(1.15,1.15)'
        fill='{$color}' stroke='none' stroke-width='0.8696'
         d='m 60.17,46.84 c -2.88,-0.21 -4.29,-1.98 -4.29,-4.83 l 0,-9.26
  	   2.88,0 0,9.8 c 0,1.55 1.65,1.64 2.85,1.52 0.85,-0.1 1.81,-0.28
  	   2.88,-0.62 l 0,-10.7 2.88,0 0,14.12 -2.88,0 0,-0.57 c -1.62,0.45
  	   -3.06,0.63 -4.32,0.54 z'/>
      <path id='path21' transform='scale(1.15,1.15)'
        fill='{$color}' stroke='none' stroke-width='0.8696'
         d='m 106.8,37.6 0,9.27 -2.8,0 0,-9.8 c 0,-2.52 -4.41,-1.34 -5.78,
  	   -0.9 l 0,10.7 -2.88,0 0,-14.12 2.88,0 0,0.56 c 3.98,-1.1 8.58,
  	   -0.99 8.58,4.29 z'/>
      <path id='path23' transform='scale(1.15,1.15)'
        fill='{$color}' stroke='none' stroke-width='0.8696'
         d='m 77.53,32.76 0,4.03 c -2.08,-0.4 -3.73,-0.4 -5.81,0 l 0,-4.03
  	   -2.91,0 0,14.11 2.91,0 0,-7.26 c 0,-1.25 5.81,-1.26 5.81,0 l 0,
  	   7.26 2.91,0 0,-14.11 -2.91,0 z'/>
      <path id='path25' transform='scale(1.15,1.15)'
        fill='{$color}' stroke='none' stroke-width='0.8696'
         d='m 85.04,42.26 c -0.17,0.25 -0.25,0.55 -0.25,0.91 0,1.61 1.75,
  	   1.57 2.91,1.38 0.84,-0.13 1.82,-0.4 2.9,-0.82 l 0,-2.62 c -1.52,
  	   -0.16 -4.53,-0.39 -5.56,1.15 z m 5.56,4.67 0,-0.28 c -2.59,0.78
  	   -6.96,1.42 -8.35,-1.7 -0.48,-1.06 -0.51,-2.89 0,-3.95 1.37,-2.86
  	   5.67,-2.85 8.35,-2.52 0,-0.52 0,-1 -0.22,-1.43 -1,-2.45 -5.07,
  	   -1.45 -6.78,-0.29 l -1.15,-2.62 c 2.43,-1.67 7.68,-2.26 9.72,0
  	   0.9,1.01 1.35,2.44 1.35,4.32 l 0,8.45 -2.92,0 z'/>
    </g>
    </svg>";
    return $svg;
  }

}
