/**
 * @file
 * Author: Synapse-studio.
 */

(function ($) {
  'use strict';

  $(document).ready(function () {
    agreementCookie();
  });

  function getCookie(name) {
    let matches = document.cookie.match(new RegExp('(?:^|; )' + name.replace(/([\.$?*|{}\(\)\[\]\\\/\+^])/g, '\\$1') + '=([^;]*)'));
    return matches ? decodeURIComponent(matches[1]) : undefined;
  }

  function agreementCookie() {
    let useCookie = getCookie('userCookies'),
      cookiewin = document.querySelector('.cookie-notice');
    if (useCookie != 'no' && cookiewin) {
      cookiewin.style.display = 'block';
      document.getElementById('cookie_close').addEventListener('click', function () {
        cookiewin.style.display = 'none';
        let date = new Date();
        date.setDate(date.getDate() + 1);
        document.cookie = 'userCookies=no; path=/; expires=' + date.toUTCString();
      });
    }
  }
})(this.jQuery);
