<?php

namespace Drupal\synhelper\Hook;

use Drupal\Core\Render\Markup;

/**
 * Preprocess Html.
 */
class PreprocessHtml {

  /**
   * Hook.
   */
  public static function hook(&$variables) {
    // No-index:
    $noindex_paths = [
      '/user/login',
      '/user/password',
      '/policy',
      '/policy/ru',
      '/policy/en',
    ];

    $noindex = [
      '#tag' => 'meta',
      '#attributes' => [
        'name' => 'robots',
        'content' => 'none',
      ],
    ];

    $current_path = \Drupal::service('path.current')->getPath();
    if (in_array($current_path, $noindex_paths)) {
      $variables['page']['#attached']['html_head'][] = [$noindex, 'indexation'];
    };
    $config = \Drupal::config('synhelper.settings');
    if ($config->get('no-index')) {
      $variables['page']['#attached']['html_head'][] = [$noindex, 'indexation'];
    }
    $host = \Drupal::request()->getHost();
    if ($config->get('no-index-1c') && strpos($host, '1c.') === 0) {
      $variables['page']['#attached']['html_head'][] = [$noindex, 'indexation'];
    }
    self::attachYandexMetricCode($variables);
  }

  /**
   *
   */
  public static function attachYandexMetricCode(&$variables) {
    $config = \Drupal::config('synhelper.settings');
    $synapse_config = \Drupal::config('synapse.settings');
    if ($config->get('ya-counter') && !$synapse_config->get('gtm-id')) {
      $path = \Drupal::service('path.current')->getPath();
      $admin = FALSE;
      if (\Drupal::currentUser()->id() == 1) {
        $admin = TRUE;
      }
      $ya_id = $config->get('ya-counter');
      if ($ya_id && substr($path, 0, 7) != '/admin/' && !$admin) {
        $script = "(function(m,e,t,r,i,k,a){m[i]=m[i]||function(){(m[i].a=m[i].a||[]).push(arguments)};
          m[i].l=1*new Date();
          for (var j = 0; j < document.scripts.length; j++) {if (document.scripts[j].src === r) { return; }}
          k=e.createElement(t),a=e.getElementsByTagName(t)[0],k.async=1,k.src=r,a.parentNode.insertBefore(k,a)})
          (window, document, 'script', 'https://mc.yandex.ru/metrika/tag.js', 'ym');
          ym({$ya_id}, 'init', {
            clickmap:true,
            trackLinks:true,
            accurateTrackBounce:true,
            webvisor:true
          });\n";
        $noscript = "<noscript><div><img src='https://mc.yandex.ru/watch/{$ya_id}' style='position:absolute; left:-9999px;' alt='' /></div></noscript>\n";
        $variables['page_bottom']['ya_metric'] = [
          '#markup' => Markup::create("<script type='text/javascript'>\n{$script}\n</script>"),
          '#allowed_tags' => ['script'],
          '#weight' => 999,
        ];
        $variables['page_bottom']['ya_metric_noscript'] = [
          '#markup' => $noscript,
          '#allowed_tags' => ['div', 'noscript', 'img'],
          '#weight' => 999,
        ];
      }
    }
  }

}
