<?php

namespace Drupal\synhelper\Hook;

use Drupal\Core\Url;

/**
 * PreprocessPage.
 */
class PreprocessPage {

  /**
   * Hook.
   */
  public static function hook(&$variables) {
    $config = \Drupal::config('synhelper.settings');
    $config_synapse = \Drupal::config('synapse.settings');
    if ($config->get('fz152')) {
      $variables['footer_policy'] = TRUE;
    }
    $metrika = [
      'ya_counter' => $config->get('ya-counter') ?? '',
      'gtm' => $config_synapse->get('gtm-id') ?? '',
      'ga4' => $config_synapse->get('ga4-id') ?? '',
    ];
    $variables['#attached']['drupalSettings']['metrika'] = $metrika;
    // Cookie agreemnet text.
    if ($config->get('enable-cookies')) {
      $url = $config->get('cookie-agreement-link') ? Url::fromUserInput($config->get('cookie-agreement-link')) : Url::fromUserInput('/policy');
      $agreement_text = $config->get('cookie-agreement-text') ? $config->get('cookie-agreement-text') : 'Продолжая пользоваться сайтом, вы соглашаетесь с условиями использования сайта и обработкой нами и нашими партнерами cookie-файлов и иной информации на сайте в соответствии с {ссылка}.';
      $link_text = $config->get('cookie-agreement-link-text') ? $config->get('cookie-agreement-link-text') : 'Политикой конфиденциальности';
      if (strpos($agreement_text, '{ссылка}') !== FALSE) {
        $agreement_text = str_replace('{ссылка}', "<a href=" . $url->toString() . " target='_blank'>" . $link_text . "</a>", $agreement_text);
      }
      $variables['cookie_agreement'] = $agreement_text;
    }
  }

}
