/**
 * @file
 */

(function () {
  "use strict";

  if (document.readyState != 'loading') {
    vueApp("#app-search");
  } else {
    window.addEventListener("DOMContentLoaded", function () {
      vueApp("#app-search");
    });
  }

  function vueApp(sel) {
    var app;
    const elements = document.querySelectorAll(sel);
    const each = Array.prototype.forEach;
    const delimiters = ["${", "}"];
    const comments = true;
    each.call(elements, function (el, i) {
      let comp_template = el.querySelector('synsearch');
      app = Vue.createApp({ delimiters, comments, el });
      app.component('synsearch', {
        template: comp_template,
        delimiters: delimiters,
        data() {
          return {
            page: 0,
            limit: 0,
            watched: 0,
            total: 0,
            items: [],
            title: '',
            noResult: false,
          }
        },
        props: {
          data: {},
        },
        methods: {
          getReviews(method = 'no-merge') {
            axios.get('/syn-search/api/get-list?title=' + this.title + '', {
              params: {
                page: this.page,
              },
            }).then((response) => {
              if (method == 'merge') {
                this.items = this.items.concat(response.data.list);
              }
              else {
                this.items = response.data.list;
              }
              this.total = response.data.total;
              if (!this.total) {
                this.noResult = true;
              }
              this.limit = response.data.limit;
              this.watched = response.data.watched;
            });
          },
          loadMore() {
            this.page++;
            this.getReviews('merge');
          },
        },
        created() {
          this.title = this.data.title;
          if (this.title) {
            this.getReviews();
          }
          document.body.classList.add("search-ready");
        },
      });
      app.mount(el);
    });
  };

})();
