<?php

namespace Drupal\synsearch\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configuration form for a syn entity type.
 */
class SearchSettingsForm extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'syn_search_settings';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('synsearch.settings');
    $form['products'] = [
      '#title' => $this->t('Search Products'),
      '#description' => $this->t('Enable products search'),
      '#type' => 'checkbox',
      '#maxlength' => 20,
      '#required' => FALSE,
      '#size' => 15,
      '#default_value' => $config->get('products'),
    ];
    $form['nodes'] = [
      '#title' => $this->t('Search Nodes'),
      '#description' => $this->t('Enable nodes search'),
      '#type' => 'checkbox',
      '#maxlength' => 20,
      '#required' => FALSE,
      '#size' => 15,
      '#default_value' => $config->get('nodes'),
    ];
    $form['actions']['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('Save'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $config = \Drupal::configFactory()->getEditable('synsearch.settings');
    $config
      ->set('products', $form_state->getValue('products'))
      ->set('nodes', $form_state->getValue('nodes'))
      ->save();
    $this->messenger()->addStatus($this->t('The configuration has been updated.'));
  }

}
