# System Module Insights

A comprehensive Drupal module analysis tool that provides advanced filtering, sorting, search capabilities, usage metrics, dependency analysis, and export functionality for all installed and available modules.

## Features

### 🔍 **1. Filtering, Sorting, and Search**
- **Real-time search**: Find modules by name or description with instant filtering
- **Status filtering**: Filter by enabled, disabled, or available modules
- **Package filtering**: Filter by package type (Core, Contrib, Custom, etc.)
- **Quick filters**: Show only custom modules or unused modules
- **Column sorting**: Click any column header to sort data

### 📁 **3. Module Information**
- **Module Path**: Full path to module directory
- **Version Information**: Version from .info.yml file
- **Package Classification**: Core, Contrib, Custom, or Other
- **Description**: Full module description with expandable text

### 📋 **4. Dependencies & Dependents**
- **Dependencies**: Modules this module depends on
- **Dependents**: Modules that depend on this module
- **Visual Indicators**: Color-coded badges and counts
- **Expandable Lists**: Click to see full dependency lists

### 🔧 **5. Configuration Overview**
- **Install Configurations**: Config files in config/install/
- **Optional Configurations**: Config files in config/optional/
- **Schema Files**: Configuration schema definitions
- **Config Item Count**: Total configuration items owned

### 📄 **6. Export Capabilities**
- **CSV Export**: Spreadsheet-compatible format
- **JSON Export**: Machine-readable data format
- **HTML/PDF Export**: Print-friendly report format
- **Column Selection**: Choose specific columns to export
- **Filtered Exports**: Export respects current filters

### 👀 **7. Highlighting & Visual Indicators**
- **Custom Modules**: Blue highlighting for modules in modules/custom/
- **Unused Modules**: Yellow highlighting for enabled modules with zero usage
- **Disabled with Dependents**: Red highlighting for potential issues
- **Package Badges**: Color-coded package type indicators
- **Status Badges**: Clear visual status indicators

### 👥 **8. Permissions & Documentation**
- **Permission Indicators**: Shows if module defines permissions
- **README Links**: Direct links to module README files
- **Drupal.org Links**: Links to contrib module pages
- **Tooltip Information**: Hover for additional details

### 🛠️ **9. Advanced Features**
- **AJAX Filtering**: Real-time updates without page reloads
- **Responsive Design**: Works on mobile and tablet devices
- **Keyboard Navigation**: Full accessibility support
- **Print Optimization**: Clean printing layout
- **URL State Management**: Bookmarkable filtered views

## Installation

1. Place the module in your `modules/custom/` directory
2. Enable the module via Drush or the admin interface:
   ```bash
   drush en system_module_insights
   ```
3. Clear cache:
   ```bash
   drush cr
   ```

## Usage

### Accessing System Module Insights

Navigate to **Administration » Reports » System Module Insights** (`/admin/reports/system-module-insights`)

### Basic Filtering

1. **Search**: Type in the search box for real-time filtering
2. **Status**: Select enabled, disabled, or available modules
3. **Package**: Filter by Core, Contrib, Custom, or other packages
4. **Quick Filters**: Check boxes for custom-only or unused-only modules

### Sorting Data

- Click any column header to sort by that column
- Click again to reverse the sort order
- Sort indicators (↑↓) show current sort direction

### Exporting Data

1. Expand the **Export Options** section in the filter form
2. Select columns to include in export (or leave empty for all columns)
3. Click export format buttons (CSV, JSON, HTML/PDF)
4. File will download with current filters applied

### Visual Indicators

- **Blue rows**: Custom modules (modules/custom/)
- **Yellow rows**: Enabled but unused modules (usage score = 0)
- **Red rows**: Disabled modules with dependents
- **📖**: README file available
- **🌐**: Drupal.org project page available
- **🔒**: Module defines permissions

## Configuration

### Module Settings

Access settings at **Administration » Configuration » System » System Module Insights** (`/admin/config/system/system-module-insights`)

#### Display Settings
- **Items per page**: Control pagination (10-500 modules)
- **Default columns**: Choose which columns are visible by default

#### Performance Settings
- **Cache duration**: How long to cache analysis data (5min - 1 day)
- **Enable AJAX**: Toggle real-time filtering functionality

#### Analysis Settings
- **Include test modules**: Whether to analyze test modules
- **Deep dependency scanning**: Detailed dependency analysis
- **Usage calculation method**: How usage scores are calculated

#### Export Settings
- **Maximum export items**: Limit export size (100-10,000)
- **Include metadata**: Add timestamps and summary to exports

## Technical Details

### Architecture

- **Service-based**: Uses Drupal services for modularity
- **Cached Analysis**: Configurable caching for performance
- **AJAX-enabled**: Real-time filtering without page reloads
- **Responsive**: Mobile-first CSS design
- **Accessible**: WCAG compliant with keyboard navigation

### Services

- **`system_module_insights.analyzer`**: Core analysis and data collection
- **`system_module_insights.exporter`**: Multi-format export functionality

### Hooks & Themes

- **`hook_theme()`**: Custom templates for table and usage badges
- **Twig templates**: Customizable output formatting
- **CSS/JS libraries**: Enhanced user interface

### Performance Considerations

- **Lazy Loading**: Module data loaded on-demand
- **Query Optimization**: Efficient database queries
- **Caching**: Configurable result caching
- **AJAX Pagination**: Smooth navigation for large datasets

## Customization

### Theming

Override Twig templates in your theme:
```
templates/
  system-module-insights-table.html.twig
  system-module-insights-usage-badge.html.twig
```

### CSS Customization

Override styles by targeting these classes:
- `.module-viewer-wrapper`
- `.module-viewer-table`
- `.custom-module`
- `.unused-module`
- `.usage-badge`

### JavaScript Extensions

Extend functionality via `Drupal.behaviors`:
```javascript
Drupal.behaviors.myModuleViewerExtension = {
  attach: function (context, settings) {
    // Custom functionality
  }
};
```

## Troubleshooting

### Common Issues

**AJAX filtering not working:**
- Check JavaScript console for errors
- Ensure jQuery and Drupal.ajax are loaded
- Try disabling AJAX in module settings

**Export not including all data:**
- Check export limits in module settings
- Verify column selections in export options
- Ensure proper permissions

**Performance issues:**
- Increase cache duration in settings
- Disable deep dependency scanning
- Reduce items per page

**Missing module data:**
- Clear Drupal cache
- Check module file permissions
- Verify .info.yml file format

### Debug Mode

Enable debug information by adding to settings.php:
```php
$config['system_module_insights.settings']['debug_mode'] = TRUE;
```

## Requirements

- Drupal 10.x or 11.x
- PHP 8.3+
- Modern browser with JavaScript enabled

## Support

For issues, feature requests, or contributions:
1. Check existing documentation
2. Search for similar issues
3. Provide detailed reproduction steps
4. Include Drupal and module version information

## License

GPL-2.0-or-later

## Changelog

### 1.0.0
- Initial release with full feature set
- Advanced filtering and sorting
- Multiple export formats
- Usage metrics and dependency analysis
- Responsive design and accessibility features
