/**
 * @file
 * Tab title animation handler script.
 */
(function animationHandler(Drupal) {
  Drupal.behaviors.tabTitleAttentionTabTitleAttention = {
    attach(context, settings) {
      const { enabled } = settings.tab_title_attention;
      const animationDelay = settings.tab_title_attention.delay;
      const { message } = settings.tab_title_attention;
      const animationType = settings.tab_title_attention.animation;
      const animationSpeed = settings.tab_title_attention.speed;

      let animationInterval;
      let previousTitle;
      let scrollAnimCurrentPos = 0;

      function startStaticAnimation() {
        document.title = message;
      }

      function startBlinkAnimation(blinkWithEmptyTitle) {
        animationInterval = setInterval(function blinkInterval() {
          if (document.title === message) {
            document.title = blinkWithEmptyTitle ? '.' : previousTitle;
          } else {
            document.title = message;
          }
        }, animationSpeed);
      }

      function startScrollAnimation() {
        animationInterval = setInterval(function scrollInterval() {
          document.title = `${message.substring(
            scrollAnimCurrentPos,
            message.length,
          )} ${message.substring(0, scrollAnimCurrentPos)}`;
          scrollAnimCurrentPos += 1;
          scrollAnimCurrentPos %= message.length;
        }, animationSpeed);
      }

      function stopAnimation() {
        clearInterval(animationInterval);
        scrollAnimCurrentPos = 0;
      }

      window.onblur = function blurHandler() {
        if (enabled) {
          previousTitle = document.title;
          switch (animationType) {
            case 'static':
              setTimeout(startStaticAnimation, animationDelay);
              break;
            case 'blink':
              setTimeout(function blinkTimeout() {
                startBlinkAnimation(false);
              }, animationDelay);
              break;
            case 'blink_empty':
              setTimeout(function blinkEmptyTimeout() {
                startBlinkAnimation(true);
              }, animationDelay);
              break;
            case 'scroll':
              setTimeout(startScrollAnimation, animationDelay);
              break;
            default:
              break;
          }
        }
      };

      window.onfocus = function focusHandler() {
        stopAnimation();
        if (previousTitle !== undefined) {
          document.title = previousTitle;
        }
      };
    },
  };
})(Drupal);
