<?php

namespace Drupal\Tests\tab_title_attention\Functional;

use Drupal\Tests\BrowserTestBase;

/**
 * Tests the settings page of the tab_title_attention module.
 *
 * @group tab_title_attention
 */
class TabTitleAttentionSettingsTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['tab_title_attention', 'system'];

  /**
   * A user with authenticated permissions.
   *
   * @var \Drupal\Core\Session\AccountInterface
   */
  protected $user;

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->config('system.site')->set('page.front', '/test-page')->save();
    $this->user = $this->drupalCreateUser([]);
    $this->drupalLogin($this->rootUser);
  }

  /**
   * Tests the settings page and saving the settings.
   */
  public function testSettings(): void {
    // Go to the settings page and check if the default settings are present.
    $this->drupalGet('/admin/config/user-interface/tab-title-attention');
    $session = $this->assertSession();
    $session->statusCodeEquals(200);
    $session->checkboxNotChecked('enabled');
    $session->fieldValueEquals('delay', 5000);
    $session->fieldValueEquals('message', "Don't forget about this tab!");
    $session->fieldValueEquals('animation', 'blink');
    $session->fieldValueEquals('speed', 4000);
    // Change the settings and check if they apply after save.
    $page = $this->getSession()->getPage();
    $page->checkField('enabled');
    $page->fillField('delay', 123);
    $page->fillField('message', 'Test Message!');
    $page->fillField('animation', 'scroll');
    $page->fillField('speed', 456);
    $page->pressButton('edit-submit');
    $session->checkboxChecked('enabled');
    $session->fieldValueEquals('delay', 123);
    $session->fieldValueEquals('message', 'Test Message!');
    $session->fieldValueEquals('animation', 'scroll');
    $session->fieldValueEquals('speed', 456);
  }

}
