## INTRODUCTION

This modules makes it simple to create a set of vertical or horizontal tabs using a render array.

The [Tabby JS library](https://github.com/cferdinandi/tabby) was chosen as it is lightweight, accessible,
just vanilla JS, and is already being used by [Webform](https://www.drupal.org/project/webform) so many Drupal installs will already have the library present.

## REQUIREMENTS

This module requires the tabby js library.

## INSTALLATION

The installation of this module is like other Drupal modules.

1. If your site is [managed via Composer](https://www.drupal.org/node/2718229),
   use Composer to download the webform module running
   ```composer require "drupal/tabby"```. Otherwise copy/upload the tabby
   module to the modules directory of your Drupal installation.

2. Enable the 'Tabby' module in 'Extend'.
   (`/admin/modules`)

3. Install the tabby js library.

   1. Install composer-installers-extender
    ```
    composer require oomphinc/composer-installers-extender
    ```

    2. Add the package definition in the repositories section.
    ```
    {
        "type": "package",
        "package": {
            "name": "cferdinandi/tabby",
            "version": "v12.0.3",
            "type": "drupal-library",
            "source": {
                "url": "https://github.com/cferdinandi/tabby.git",
                "type": "git",
                "reference": "tags/v12.0.3"
            }
        }
    }
    ```

    3. Install the library:
    ```
    composer require cferdinandi/tabby:v12.0.3
    ```

## JS instance access

All tab instances are stored against the tabby Drupal behavior.

So on the example page, `/admin/tabby-example`, running

```
console.log(Drupal.behaviors.tabby.instances)
```

would return

```
{
  "my-awesome-tabs": <TabbyObject>,
  "tabby-1": <TabbyObject>,
  "tabby-2": <TabbyObject>
}
```

## EXAMPLES

```
$build['tabs'] = [
  '#theme' => 'tabby_tabs',
  '#labels' => ['Label One', 'Label Two'],
  '#content' => [
    ['#markup' => 'Content One'],
    ['#markup' => 'Content Two'],
  ],
];
```

For more examples see TabbyExampleController.

## OTHER TAB MODULES

- [Quick Tabs](https://www.drupal.org/project/quicktabs)
  - Not possible to create tabs with a render array.
  - Not accessible unless you use quicktabs-accessible library which currently has some issues with D11.
 - [Block Tabs](https://www.drupal.org/project/blocktabs)
   - Not possible to create tabs with a render array.
   - No Drupal 11 version
   - Is based on jQuery
 - [Bootstrap Horizontal Tabs](https://www.drupal.org/project/bootstrap_horizontal_tabs)
   - Not possible to create tabs with a render array.
   - Does not come with a JS library - you have to install Bootstrap yourself.
