(function (Tabby, Drupal, once) {
  'use strict'
  Drupal.behaviors.tabby = {

    /**
     * Each tab instance keyed by instance id.
     */
    instances: {},

    /**
     * Tab behaviours keyed by instance id and tab index.
     */
    behaviors: {},

    /**
     * Flag for if event listners have been bound.
     */
    boundEventListener: false,

    /**
     * Attach behaviours.
     *
     * @param context
     * @param settings
     */
    attach: function (context, settings) {

      // Find all tabby instances.
      const instances = once('tabby', '.tabby-wrapper', context)

      // Initialize tabby for each instance.
      for (const instance of instances) {

        // Store the instance in this so other modules can have access.
        this.instances[instance.id] = new Tabby('#' + instance.id + ' [data-tabs]')
        this.behaviors[instance.id] = settings.tabby.behaviors[instance.id]

        // Bind event listener once.
        if (!this.boundEventListener) {
          document.addEventListener('tabby', this.tabChange.bind(this))
          this.settings = settings
        }

        // Bind behaviors for initial tab.
        const target = instance.querySelector('a[aria-selected="true"]')
        this.tabChange({ target })
      }
    },

    /**
     * Tab change event.
     *
     * Used to bind any behaviors for specific tabs.
     *
     * @param event
     */
    tabChange (event) {
      const tabLink = event.target
      const tabListItem = tabLink.parentNode
      const tabIndex = Array.prototype.indexOf.call(tabListItem.parentNode.children, tabListItem)
      const wrapper = tabLink.closest('.tabby-wrapper')

      // Get behaviors for this tab in this instance.
      const behaviors = this.behaviors[wrapper.id][tabIndex]
      if (!behaviors) {
        return
      }

      // Get behavior context (the tab contents).
      const tabContent = wrapper.querySelector('#' + tabLink.getAttribute('aria-controls'))

      // Bind behaviours.
      for (const behavior of behaviors) {
        if (behavior in Drupal.behaviors) {
          Drupal.behaviors[behavior].attach(tabContent, this.settings)
        }
      }
    }
  }
})(Tabby, Drupal, once)
