<?php

namespace Drupal\Tests\tabby\FunctionalJavascript;

use Drupal\FunctionalJavascriptTests\WebDriverTestBase;

/**
 * Tests the field widget.
 *
 * @group tabby
 */
class TabbyTest extends WebDriverTestBase {

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'tabby',
    'tabby_test',
  ];

  /**
   * Tests the widget.
   *
   * Tests that behaviors get attached on tab change.
   */
  public function testBehaviors(): void {

    // Load the test page.
    $this->drupalGet('tabby-test');

    // Here we are testing that behaviors get attached on tab change.
    // Tab 1 contents is visible so the width should be correct.
    $contentsOne = $this->getSession()->getPage()->find('css', '#tabby-1-0')->getText();
    $this->assertEquals('Content One Tabby test one has width of 1008px', $contentsOne);

    // Tab 2 is hidden, so the width should be 0.
    $contentsTwo = $this->getSession()->getPage()->find('css', '#tabby-1-1')->getText();
    $this->assertEquals('', $contentsTwo);

    // Change to tab 2.
    $this->getSession()->getPage()->clickLink('tabby-toggle_tabby-1-1');

    // Check contents of tab 1 are hidden.
    $contentsOne = $this->getSession()->getPage()->find('css', '#tabby-1-0')->getText();
    $this->assertEquals('', $contentsOne);

    // The behavior should run and update the contents.
    $contentsTwo = $this->getSession()->getPage()->find('css', '#tabby-1-1')->getText();
    $this->assertEquals('Content Two Tabby test two has width of 1008px', $contentsTwo);

  }

}
