<?php

declare(strict_types=1);

namespace Drupal\tabby\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Template\Attribute;

/**
 * Returns responses for Tabby routes.
 */
final class TabbyExampleController extends ControllerBase {

  /**
   * Builds the response.
   */
  public function __invoke(): array {
    $build['title1'] = [
      '#markup' => $this->t('<h2>Horizontal</h2>'),
    ];

    $labels = [
      $this->t('Rotate'),
      $this->t('Implode'),
      $this->t('Pop'),
    ];

    $content = [
      [
        '#theme' => 'item_list',
        '#items' => [
          $this->t('This is a list item'),
          $this->t('This is another list item'),
          $this->t('This is a third list item'),
        ],
      ],
      [
        '#markup' => $this->t('This is some content'),
      ],
      [
        '#markup' => $this->t('This is some more content'),
      ],
    ];

    $build['tabs'] = [
      '#theme' => 'tabby_tabs',
      '#labels' => $labels,
      '#content' => $content,
    ];

    $build['title2'] = [
      '#markup' => $this->t('<h2>Vertical</h2>'),
    ];

    $labels = [
      $this->t('One'),
      $this->t('Two'),
      $this->t('Three'),
    ];

    $content = [
      ['#markup' => 'A'],
      ['#markup' => 'B'],
      ['#markup' => 'C'],
    ];

    $build['tabs_two'] = [
      '#theme' => 'tabby_tabs',
      '#labels' => $labels,
      '#content' => $content,
      '#vertical' => TRUE,
    ];

    $build['title3'] = [
      '#markup' => $this->t('<h2>Custom attributes</h2>'),
    ];

    $labels = [
      [
        'content' => $this->t('One'),
        'attributes' => new Attribute(),
      ],
      [
        'content' => $this->t('Two'),
        'attributes' => new Attribute(),
      ],
      [
        'content' => $this->t('Three'),
        'attributes' => new Attribute(),
      ],
    ];
    $labels[0]['attributes']->addClass('first-tab');
    $labels[1]['attributes']->addClass('second-tab');
    $labels[2]['attributes']->addClass('third-tab');

    $content = [
      [
        'content' => ['#markup' => 'A'],
        'attributes' => new Attribute(),
      ],
      [
        'content' => ['#markup' => 'B'],
        'attributes' => new Attribute(),
      ],
      [
        'content' => ['#markup' => 'C'],
        'attributes' => new Attribute(),
      ],
    ];
    $content[0]['attributes']->addClass('first-content');
    $content[1]['attributes']->addClass('second-content');
    $content[2]['attributes']->addClass('third-content');

    $build['tabs_three'] = [
      '#theme' => 'tabby_tabs',
      '#labels' => $labels,
      '#content' => $content,
      '#vertical' => TRUE,
      '#id' => 'my-awesome-tabs',
    ];

    $build['tabs'] = [
      '#theme' => 'tabby_tabs',
      '#labels' => ['Label One', 'Label Two'],
      '#content' => [
        ['#markup' => 'Content One'],
        ['#markup' => 'Content Two'],
      ],
    ];

    return $build;
  }

}
