<?php

declare(strict_types=1);

namespace Drupal\tabby_test\Controller;

use Drupal\Core\Controller\ControllerBase;

/**
 * Returns responses for Tabby test routes.
 */
final class TabbyTestController extends ControllerBase {

  /**
   * Builds the response.
   */
  public function __invoke(): array {
    $build['tabs_test'] = [
      '#theme' => 'tabby_tabs',
      '#labels' => ['Label One', 'Label Two'],
      '#content' => [
        ['#markup' => 'Content One<div class="tabby-test-one"></div>'],
        ['#markup' => 'Content Two<div class="tabby-test-two"></div>'],
      ],
      '#behaviors' => [
        ['tabbyTestBehaviorOne'],
        ['tabbyTestBehaviorTwo'],
      ],
    ];
    $build['#attached']['library'][] = 'tabby_test/tabby_test_behavior_one';
    $build['#attached']['library'][] = 'tabby_test/tabby_test_behavior_two';
    return $build;
  }

}
