# Table Header Scope Attribute

In a table, the scope attribute indicates the direction and range of data cells
covered by `<th>` elements. The Table Header Scope Attribute module provides
text format filters that process `<table>` elements to improve accessibility:

1. **Set scope attribute for table headers**: Automatically sets the correct
   `scope` attribute on `<th>` elements based on their position in the table.
1. **Transform empty table header to table data**: Converts empty `<th>`
   elements into `<td>` elements, as empty headers provide no semantic value.

For example, the following table:

```html
<table>
  <thead>
    <tr>
      <th></th>
      <th>Column header 1</th>
      <th>Column header 2</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>Row header 1</th>
      <td>Value A</td>
      <td>Value B</td>
    </tr>
    <tr>
      <th>Row header 2</th>
      <td>Value C</td>
      <td>Value D</td>
    </tr>
  </tbody>
</table>
```

Will be transformed to:

```html
<table>
  <thead>
    <tr>
      <td></td>
      <th scope="col">Column header 1</th>
      <th scope="col">Column header 2</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th scope="row">Row header 1</th>
      <td>Value A</td>
      <td>Value B</td>
    </tr>
    <tr>
      <th scope="row">Row header 2</th>
      <td>Value C</td>
      <td>Value D</td>
    </tr>
  </tbody>
</table>
```

For a full description of the module, visit the
[project page](https://www.drupal.org/project/table_header_scope_attribute).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/table_header_scope_attribute).

## REQUIREMENTS

This module requires no modules outside of Drupal core.


## INSTALLATION

Install as you would normally install a contributed Drupal module. For further
information, see
[Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).


## CONFIGURATION

1. Go to Administration » Configuration » Content authoring » Text formats
   and editors
1. Edit a text format, for example, "Basic HTML"
1. Enable both filters:
   - "Set scope attribute for table headers"
   - "Transform empty table header to table data"
1. Ensure the filters are ordered correctly:
   - "Set scope attribute for table headers" must come *before*
     "Transform empty table header to table data"
   - Both filters should be below the "Limit allowed HTML tags and correct
     faulty HTML" filter

**Important**: The filter order is critical. The scope attribute filter must
run before the empty header transformation, otherwise empty `<th>` elements
will be converted to `<td>` before receiving their scope attributes, causing
remaining headers to be incorrectly scoped.

Assuming the filters are enabled for a text format that can be used on, e.g., a
basic page (node). Create or edit a basic page and enter a table. Indicate the
`<th>` elements in the `<table>` and save the node. When viewing the (source of
the) basic page, the scope attributes are correctly set to the `<th>` tags, and
empty `<th>` elements are converted to `<td>` elements.

## CONTRIBUTING

Contributions are welcome! You may set up your local development environment
using any stack you prefer. DDEV is optional and supported.

If you choose to use DDEV:

1. Clone the repository.
1. Install DDEV. See [DDEV installation guide](https://docs.ddev.com/en/stable/users/install/).
1. Run the following commands:
   ```
   ddev start
   ddev poser
   ddev symlink-project
   ```
   For more information about the `poser` and `symlink-project` commands, visit
   [ddev-drupal-contrib commands](https://github.com/ddev/ddev-drupal-contrib#commands).

After your environment is ready, you need to install the Drupal site and enable
the module. Drush is available in all setups and can be used as follows:

- Install the site:
  ```
  drush site:install
  ```
- Enable the module:
  ```
  drush pm:install table_header_scope_attribute
  ```
