<?php

declare(strict_types=1);

namespace Drupal\table_header_scope_attribute;

/**
 * Interface for validating HTML elements.
 */
interface HtmlElementValidatorInterface {

  /**
   * Checks if an element's content is empty.
   *
   * An element is considered empty if it contains only whitespace (including
   * non-breaking spaces and other Unicode whitespace characters) and no child
   * elements that provide semantic meaning.
   *
   * @param \DOMElement $element
   *   The element to check.
   *
   * @return bool
   *   TRUE if the element's content is empty, FALSE otherwise.
   */
  public function isElementContentEmpty(\DOMElement $element): bool;

}
