<?php

declare(strict_types=1);

namespace Drupal\Tests\table_header_scope_attribute\Kernel\Hook;

use Drupal\Core\DependencyInjection\ClassResolverInterface;
use Drupal\Core\Entity\EntityFormBuilderInterface;
use Drupal\filter\Entity\FilterFormat;
use Drupal\KernelTests\KernelTestBase;
use Drupal\table_header_scope_attribute\Hook\TableHeaderScopeAttributeHooks;
use PHPUnit\Framework\Attributes\DataProvider;
use PHPUnit\Framework\Attributes\Group;

/**
 * Tests the TableHeaderScopeAttributeHooks form alterations.
 */
#[Group('table_header_scope_attribute')]
class TableHeaderScopeAttributeHooksTest extends KernelTestBase {

  /**
   * The entity form builder service.
   */
  private EntityFormBuilderInterface $entityFormBuilder;

  /**
   * The class resolver service.
   */
  private ClassResolverInterface $classResolver;

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'filter',
    'user',
    'table_header_scope_attribute',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->entityFormBuilder = $this->container->get('entity.form_builder');
    $this->classResolver = $this->container->get('class_resolver');
  }

  /**
   * Ensures our validation is added when a filter format is created or edited.
   */
  #[DataProvider('provideFormOperations')]
  public function testFormFilterFormatAddFormAlter(string $operation): void {
    $form = $this->entityFormBuilder->getForm(FilterFormat::create(), $operation);

    $this->assertNotEmpty($form['#validate'], 'Form validation callbacks should not be empty.');
    $this->assertContains(
      [
        $this->classResolver->getInstanceFromDefinition(TableHeaderScopeAttributeHooks::class),
        'validateFilterFormatAddEditForm',
      ],
      $form['#validate'],
      'The TableHeaderScopeAttributeHooks validation callback should be added to the form.'
    );
  }

  /**
   * Data provider for testFormFilterFormatAddFormAlter().
   *
   * @return \Generator
   *   Test cases with form operations that should be tested.
   */
  public static function provideFormOperations(): \Generator {
    yield 'add' => ['add'];
    yield 'edit' => ['edit'];
  }

}
