<?php

declare(strict_types=1);

namespace Drupal\Tests\table_header_scope_attribute\Unit\Plugin;

use Drupal\Component\Utility\Html;

/**
 * Provides shared test helper methods for table header filter tests.
 */
trait TableHeaderFilterTestTrait {

  /**
   * Configures the HTML element validator stub for empty element detection.
   *
   * @param array $empty_th_contents
   *   Array of text contents that should be considered empty.
   */
  protected function configureEmptyElementValidator(array $empty_th_contents): void {
    $this->htmlElementValidator
      ->method('isElementContentEmpty')
      ->willReturnCallback(static function (\DOMElement $element) use ($empty_th_contents): bool {
        if ($element->tagName !== 'th') {
          return FALSE;
        }

        $element_content = trim($element->textContent);

        foreach ($empty_th_contents as $empty_value) {
          $normalized_empty_value = trim(Html::decodeEntities($empty_value));
          if ($element_content === $normalized_empty_value) {
            return TRUE;
          }
        }

        return FALSE;
      });
  }

}
