# Tablesorter JS

A lightweight, jQuery 4 compatible client-side table sorting module for Drupal.

## Motivation

The [Tablesorter](https://www.drupal.org/project/tablesorter) module uses the
[Mottie tablesorter](https://github.com/Mottie/tablesorter) library, which is
not compatible with jQuery 4. Drupal 11 ships with jQuery 4, causing JavaScript
errors on any page with sortable tables.

The Mottie library uses `.bind()` and `.unbind()` methods (~100+ instances)
which were removed in jQuery 4. The maintainer stated they would
[keep using deprecated methods](https://github.com/Mottie/tablesorter/issues/1401)
for backwards compatibility, and a [fix submitted via PR #1293](https://github.com/Mottie/tablesorter/pull/1293)
was never merged.

See [Drupal issue #3517103](https://www.drupal.org/project/tablesorter/issues/3517103)
for details.

This module provides a simple, modern replacement (~70 lines of JavaScript)
that covers the core table sorting functionality.

## When to Use This Module

Use this module when you have:

- **Small to medium tables** displayed entirely on the page (no server-side paging)
- **Static content** that doesn't need to query the database on sort
- **Simple sorting needs** (text and numeric columns)

Do **not** use this module when you have:

- **Large datasets** with thousands of rows (use server-side sorting instead)
- **Paged tables** where sorting should re-query the database
- **Complex sorting** needs (custom parsers, multi-column sort, filters)

For server-side sorting, use Drupal core's built-in
[TableSort](https://api.drupal.org/api/drupal/core!lib!Drupal!Core!Utility!TableSort.php/11)
functionality.

For full-featured client-side tables (filtering, paging, etc.), see
[DataTables](https://www.drupal.org/project/datatables) once it has Drupal 11
support.

## Installation

```bash
composer require drupal/tablesorter_js
drush en tablesorter_js
```

## Usage

Add the class `tablesorter` to any HTML table:

```html
<table class="tablesorter">
  <thead>
    <tr>
      <th>Name</th>
      <th>Price</th>
    </tr>
  </thead>
  <tbody>
    <tr><td>Apple</td><td>$1.50</td></tr>
    <tr><td>Banana</td><td>$0.75</td></tr>
  </tbody>
</table>
```

Click any column header to sort. Click again to reverse the sort order.

Works automatically with the [Tablefield](https://www.drupal.org/project/tablefield)
module's "sortable" checkbox option.

## Features

- Client-side sorting (no page reload)
- Automatic numeric vs text detection
- Handles currency ($1,234.56) and percentages
- Keyboard accessible (Enter/Space to sort)
- ARIA attributes for screen readers
- Automatic zebra striping (odd/even classes)
- jQuery 4 compatible (Drupal 11+)
- Also works with Drupal 10.3+

## CSS Classes

The module uses the same CSS classes as the original tablesorter for
compatibility:

- `tablesorter-headerAsc` - Applied to header when sorted ascending
- `tablesorter-headerDesc` - Applied to header when sorted descending
- `odd` / `even` - Applied to table rows for zebra striping
