<?php

namespace Drupal\tacjs_domain\Form\Steps;

use Drupal\Core\Config\Config;
use Drupal\Core\Form\FormStateInterface;
use Drupal\domain_config_ui\DomainConfigUIManager;
use Drupal\tacjs\Form\Steps\ManageDialog;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Manage TacJS configuration for a domain.
 *
 * @package Drupal\tacjs_domain\Form\Steps
 */
class DomainManageDialog extends ManageDialog {

  /**
   * {@inheritdoc}
   */
  public function __construct(
    protected DomainConfigUIManager $domainConfigUIManager,
  ) {}

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('domain_config_ui.manager'),
    );
  }

  /**
   * {@inheritDoc}
   */
  protected function processSubmit(FormStateInterface $form_state, Config $config) {
    parent::processSubmit($form_state, $config);
    $id = $this->domainConfigUIManager->getActiveDomainId();
    $config->set('active.suffix', $id);
  }

}
