<?php

namespace Drupal\tacjs_domain\EventSubscriber;

use Drupal\Core\Config\ConfigCollectionEvents;
use Drupal\Core\Config\ConfigCrudEvent;
use Drupal\Core\File\FileSystemInterface;
use Drupal\domain_config\Config\DomainConfigOverride;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Event subscriber for configuration deletion.
 */
class ConfigSubscriber implements EventSubscriberInterface {

  /**
   * The file system service.
   *
   * @var \Drupal\Core\File\FileSystemInterface
   */
  protected $fileSystem;

  public function __construct(FileSystemInterface $file_system) {
    $this->fileSystem = $file_system;
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents() {
    $events[ConfigCollectionEvents::DELETE_IN_COLLECTION][] = ['onConfigDelete'];
    return $events;
  }

  /**
   * React to configuration deletion.
   */
  public function onConfigDelete(ConfigCrudEvent $event) {
    $config = $event->getConfig();
    if ($config instanceof DomainConfigOverride) {
      if ($config->getName() === 'tacjs.settings') {
        $domain_id = $config->getDomainId();
        _tacjs_domain_delete_active_services_file($domain_id);
      }
    }
  }

}
