<?php

namespace Drupal\tacjs_domain\Form\Steps;

use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Language\LanguageManagerInterface;
use Drupal\domain_config_ui\DomainConfigUIManager;
use Drupal\tacjs\Form\Steps\AddServices;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Manage TacJS configuration for a domain.
 *
 * @package Drupal\tacjs_domain\Form\Steps
 */
class DomainAddServices extends AddServices {

  use DomainStepsTrait;

  public function __construct(
    LanguageManagerInterface $language_manager,
    ModuleHandlerInterface $module_handler,
    DomainConfigUIManager $domain_config_ui_manager,
  ) {
    parent::__construct($language_manager, $module_handler);
    $this->domainConfigUIManager = $domain_config_ui_manager;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('language_manager'),
      $container->get('module_handler'),
      $container->get('domain_config_ui.manager'),
    );
  }

}
