<?php

namespace Drupal\tacjs_domain\Form\Steps;

use Drupal\domain_config_ui\DomainConfigUIManager;
use Drupal\tacjs\Form\Steps\ManageDialog;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Manage TacJS configuration for a domain.
 *
 * @package Drupal\tacjs_domain\Form\Steps
 */
class DomainManageDialog extends ManageDialog {

  use DomainStepsTrait;

  public function __construct(
    DomainConfigUIManager $domain_config_ui_manager,
  ) {
    $this->domainConfigUIManager = $domain_config_ui_manager;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('domain_config_ui.manager'),
    );
  }

}
