<?php

namespace Drupal\tacjs_domain\Form\Steps;

use Drupal\Core\Config\Config;
use Drupal\Core\Form\FormStateInterface;
use Drupal\domain_config_ui\DomainConfigUIManager;

/**
 * Trait providing domain-specific step logic for forms.
 *
 * This trait adds functionality for handling domain configuration
 * during form submission in a multi-domain environment.
 */
trait DomainStepsTrait {

  /**
   * The domain config UI manager.
   *
   * @var \Drupal\domain_config_ui\DomainConfigUIManager
   */
  protected DomainConfigUIManager $domainConfigUIManager;

  /**
   * {@inheritDoc}
   */
  protected function processSubmit(FormStateInterface $form_state, Config $config) {
    parent::processSubmit($form_state, $config);
    if ($this->domainConfigUIManager->isRegisteredConfiguration('tacjs.settings')) {
      $id = $this->domainConfigUIManager->getActiveDomainId();
      $config->set('active.suffix', $id);
    }
  }

}
