/**
 * Piano Analytics Tarteaucitron service for Drupal.
 */
(($, Drupal) => {
  // Replace default initializeAndTrackPage by custom implementation.
  if (Drupal.pianoanalytics) {
    Drupal.pianoanalytics.initializeAndTrackPageDeferred =
      Drupal.pianoanalytics.initializeAndTrackPage;
    Drupal.pianoanalytics.initializeAndTrackPage = (drupalSettings) => {
      if (drupalSettings.tacjs.services.tacjs_pianoanalytics) {
        // If the service is enabled, initialize and track the page using Tarteaucitron.
        Drupal.tacjs_pianoanalytics = {
          initializeAndTrackPage() {
            Drupal.pianoanalytics.initializeAndTrackPageDeferred(
              drupalSettings,
            );
          },
        };
      } else {
        // If the service is not enabled, call the original function.
        Drupal.pianoanalytics.initializeAndTrackPageDeferred(drupalSettings);
      }
    };
  }
})(jQuery, Drupal);
