<?php

namespace Drupal\tailwind_merge_classes\Twig;

use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;
use TailwindMerge\TailwindMerge;

class TailwindMergeClassesTwigExtension extends AbstractExtension {

    /**
     * Registers custom Twig functions.
     *
     * @return \Twig\TwigFunction[]
     *   An array of custom Twig functions.
     */
    public function getFunctions() {
        return [
            new TwigFunction('tw_merge', [$this, 'mergeTailwindClasses']),
        ];
    }

    /**
     * Merges Tailwind CSS classes, avoiding duplication.
     *
     * @param string ...$classes
     *   Tailwind classes to merge.
     *
     * @return string
     *   Merged classes.
     */
    public function mergeTailwindClasses(...$classes): string {
        // Merge the classes using the TailwindMerge library.
        $tw = TailwindMerge::instance();

        return $tw->merge(...$classes);
    }

}
