# Tailwind Merge Classes

**Tailwind Merge Classes** is a Drupal module with a Twig extension that merges multiple Tailwind CSS classes and automatically resolves conflicts, ensuring an optimized and clean class list.

---

## Post-Installation

Once you install the **Tailwind Merge Classes** module, there's no need for extra configuration or managing content types. Simply enable the module and start using it in your Twig files.

To merge Tailwind CSS classes, use the `tw_merge` function in your Twig templates. It will automatically handle merging and resolving conflicts without requiring additional configuration.

---

## Third-Party Libraries

This module depends on the [tailwind-merge-php](https://github.com/gehrisandro/tailwind-merge-php) library, installed via Composer, to handle the merging of Tailwind CSS classes.

### Important Notes:
- **Tailwind CSS Version**: Requires Tailwind CSS 3.x. (Not compatible with version 4 or higher.)
- **PHP Version**: Requires PHP 8.1 or higher.
- Permission has been granted to use this library within the module.

---

## Example Usage

To merge classes in your Twig template, use the following syntax:

```twig
<div class="{{ tw_merge('w-10 h-10 px-5 py-8', 'w-20 h-20 p-10') }}"></div>

{# Example Output: 'w-20 h-20 p-10' (conflicts resolved) #}

{# You can also pass an array of classes: #}
<div class="{{ tw_merge(['w-10', 'h-10', 'px-5', 'py-8', 'w-20', 'h-20', 'p-10']) }}"></div>

{# Example Output: 'w-20 h-20 p-10' #}
