<?php

namespace Drupal\tapis_app;

/**
 * Class DrupalIds.
 *
 * Defines constants for Drupal IDs.
 *
 * @package Drupal\tapis_app
 */
final class DrupalIds {
  const NODE_BUNDLE_APP = "tapis_app";

  const OVERRIDE_NUM_NODES = "tapis_app_override_num_nodes";
  const OVERRIDE_CORES_PER_NODE = "tapis_app_override_node_cores";
  const OVERRIDE_MEMORY = "tapis_app_override_memory";
  const OVERRIDE_MAX_RUNTIME = "tapis_app_override_max_runtime";

  const APP_TYPE = "tapis_app_type";
  const APP_AVAILABLE_SYSTEMS = "tapis_app_available_systems";
  const APP_BATCH_SCHED_OPTIONS = "tapis_app_batch_sched_options";
  const APP_CONTAINER_ARGS = "tapis_app_container_args";
  const APP_CONTAINER_IMAGE_SOURCE = "tapis_app_container_image_source";
  const APP_EXECUTABLE_PATH = "tapis_app_executable_path";
  const APP_SCHEDULER_PROFILE = "tapis_app_scheduler_profile";
  const APP_CONTAINER_IMAGE_URI = "tapis_app_container_image_uri";
  const APP_CONTAINER_PORT = "tapis_app_container_port";
  const APP_CORES_PER_NODE = "tapis_app_cores_per_node";
  const APP_DEFAULT_SYSTEM = "tapis_app_default_system";
  const APP_ENV_VARS = "tapis_app_env_vars";
  const APP_FIXED_COMMAND = "tapis_app_fixed_command";
  const APP_INPUT_TYPE = "tapis_app_input_type";
  const APP_DESCRIPTION = "tapis_app_description";
  const APP_MAX_MINUTES = "tapis_app_max_minutes";
  const APP_MAX_JOBS = "tapis_app_max_jobs";
  const APP_MAX_JOBS_PER_USER = "tapis_app_max_jobs_per_user";
  const APP_MEMORY_MB = "tapis_app_memory_mb";
  const APP_NUM_NODES = "tapis_app_num_nodes";
  const APP_OWNER = "tapis_app_owner";
  const APP_RUNTIME = "tapis_app_runtime";
  const APP_RUNTIME_OPTIONS = "tapis_app_runtime_options";
  const APP_STATUS = "tapis_app_status";
  const APP_SHORT_DESCRIPTION = "tapis_app_short_description";
  const APP_TAGS = "tapis_app_tags";
  const APP_TAPIS_ID = "tapis_app_id";
  const APP_TENANT = "tapis_app_tenant";
  const APP_USE_BATCH_SCHEDULER = "tapis_app_use_batch_scheduler";
  const APP_VERSION = "tapis_app_version";

  const APP_WEBFORM = "tapis_app_form";

  const APP_RESTARTABLE = "app_restartable";

  const IS_MPI = "tapis_app_is_mpi";
  const MPI_CMD = "tapis_app_mpi_cmd";

  const APP_SHOW_GENERATED_COMMAND = "tapis_app_show_generated_command";
  const APP_JOB_WORKING_DIR_PREFIX = "tapis_app_job_working_dir_prefix";

  const APP_ADD_JOB_FOLDER = "tapis_app_add_job_folder";
  const APP_UPDATE_APP_WEBFORM = "tapis_app_update_app_webform";

  // @todo Need to disable field_ for this
  // const CAN_USER_OVERRIDE_JOB_RESOURCES = "tapis_app_can_override_resources";
  // "tapis_app_override_job_resources";
}
