<?php

namespace Drupal\tapis_app\Exception;

use Drupal\tapis_tenant\Exception\TapisException;

/**
 * Class TapisAppException.
 *
 * This class is used to throw exceptions specific to the Tapis App module.
 *
 * @package Drupal\tapis_app\Exception
 */
class TapisAppException extends TapisException {

  /**
   * Constructs a new TapisAppException.
   *
   * @param string $message
   *   The exception message.
   * @param int $code
   *   The exception code.
   * @param \Throwable|null $previous
   *   The previous throwable used for the exception chaining.
   */
  public function __construct($message, $code = 0, \Throwable $previous = NULL) {
    $message = "Tapis App Exception: " . $message;
    parent::__construct($message, $code, $previous);
  }

}
