# tapis_auth

This module provides a Drupal integration for Tapis auth.

## Overview
In order to access Tapis APIs from Drupal, we need to have a valid JWT access token that represents the site user doing the operation (e.g., submitting a job, creating an app etc.).
Moreover, Tapis will only accept the access tokens that are signed by its Tokens service, and only the Authenticator service can make API calls to the Tokens service to mint new access tokens.
In our case, Drupal is the Authenticator service, since all user identity information is managed by Drupal.
Therefore, only Drupal will be able to make API calls to Tapis's Tokens service in order to mint JWT access tokens for site users (when performing Tapis operations on behalf of them).

To do this, Drupal will first provide its service password to the Tapis tokens service in order to get back a JWT access token representing itself as the Authenticator service.
Next, it will use its own JWT access token to mint JWT access tokens for the site users, as needed on-demand.
For instance, say user A submits a job but they don't have an access token stored in Drupal yet.
This module will automatically use its Authenticator service token to make an API call to the Tapis Tokens service, requesting a new JWT access token for the site user performing the operation.
This module will also automatically fetch new access tokens if a site user tries to perform an operation and they have an expired access token in the Drupal database.
Finally, JWT access tokens are only valid within a single tenant. For instance, `User_0` in `tenant A` is not the same as `User_0` in `tenant B`.

In essence, this module provides a Drupal service that performs all operations necessary for successfully authenticating site users with Tapis via JWT tokens.

For more info on Tapis authentication, refer to: https://tapis.readthedocs.io/en/latest/technical/authentication.html#id2

## How this module works
This module defines a custom Entity called `TapisToken` that stores the various JWTs minted via the Tapis tokens service.
It also defines & exposes a `TapisTokenProvider` Drupal service that any module can use to fetch Tapis tokens for users.
This service takes care of auto-renewing expired tokens, fetching new tokens from scratch, etc.
It is currently used by modules like `tapis_job`, `tapis_app`, etc. to perform Tapis operations on behalf of site users.
As a result, this is a dependency for all Tapis modules (other than `tapis_tenant`).

## Token generation flow
![](./assets/tapis-auth-readme-pic1.png)
