<?php

namespace Drupal\tapis_auth\Exception;

use Drupal\tapis_tenant\Exception\TapisException;

/**
 * Class TapisAuthException.
 *
 * Exception class for Tapis Auth module.
 */
class TapisAuthException extends TapisException {

  /**
   * TapisAuthException constructor.
   *
   * @param string $message
   *   Error message.
   * @param int $code
   *   Error code.
   * @param \Throwable|null $previous
   *   Previous error.
   */
  public function __construct($message, $code = 0, \Throwable $previous = NULL) {
    $message = "Tapis Auth Exception: " . $message;
    parent::__construct($message, $code, $previous);
  }

}
