<?php

namespace Drupal\tapis_auth;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\EntityChangedInterface;
use Drupal\user\EntityOwnerInterface;

/**
 * Provides an interface defining a token entity type.
 */
interface TapisTokenInterface extends ContentEntityInterface, EntityOwnerInterface, EntityChangedInterface {

  /**
   * Set the access token for this Tapis token.
   *
   * @param string $accessToken
   *   Access token.
   */
  public function setAccessToken($accessToken);

  /**
   * Get the access token for this Tapis token.
   */
  public function getAccessToken();

  /**
   * Set the refresh token for this Tapis token.
   *
   * @param string $refreshToken
   *   Refresh token.
   */
  public function setRefreshToken($refreshToken);

  /**
   * Get the refresh token for this Tapis token.
   */
  public function getRefreshToken();

  /**
   * Get the subject type for this Tapis token.
   *
   * The subject type indicates who this Tapis token is for.
   * It can be one of: service, user.
   *
   * Service Tapis tokens are used by services like Drupal
   * to interact w/ the Tapis APIs on behalf of the site.
   *
   * User Tapis tokens are used by services like Drupal
   * to interact w/ the Tapis APIs on behalf of the end user.
   */
  public function getSubjectType();

  /**
   * Get the service username for this Tapis token.
   *
   * This is only applicable for Tapis service tokens.
   */
  public function getService();

  /**
   * Get the tenant info for this token's tenant.
   */
  public function getTenant();

  /**
   * Get the tenant id for this token.
   */
  public function getTenantId();

}
