<?php

namespace Drupal\tapis_job;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\Display\EntityViewDisplayInterface;
use Drupal\Core\Entity\EntityChangedInterface;
use Drupal\Core\Entity\EntityInterface;
use Drupal\user\EntityOwnerInterface;

/**
 * Provides an interface defining a job entity type.
 */
interface TapisJobInterface extends ContentEntityInterface, EntityOwnerInterface, EntityChangedInterface {

  /**
   * Alters the job's view to fetch the latest status from Tapis, etc.
   *
   * @param array $build
   *   The build array.
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *   The entity.
   * @param \Drupal\Core\Entity\Display\EntityViewDisplayInterface $display
   *   The entity view interface.
   * @param string $view_mode
   *   The view mode.
   */
  public static function alterJobView(array &$build, EntityInterface $entity, EntityViewDisplayInterface $display, $view_mode);

  /**
   * Get the Tapis JSON definition for this job.
   */
  public function getTapisDefinition();

  /**
   * Set the Tapis JSON definition for this job.
   *
   * @param ?array $definition
   *   The definition.
   */
  public function setTapisDefinition(?array $definition);

  /**
   * Set some custom properties for this job.
   *
   * (which will be used for launching the job
   * and converting it to JSON for Tapis, etc.)
   *
   * @param array $properties
   *   The property array.
   */
  public function setCustomProperties(array $properties);

  /**
   * Set the job's status.
   *
   * @param ?string $status
   *   The job status.
   */
  public function setStatus(?string $status);

  /**
   * Get the job's status.
   */
  public function getStatus();

  /**
   * Set the job's condition.
   *
   * @param ?string $condition
   *   The job status.
   */
  public function setCondition(?string $condition);

  /**
   * Get the job's condition.
   */
  public function getCondition();

  /**
   * Set the job's usage.
   *
   * @param ?string $jobUsage
   *   An associative array representing the job usage.
   */
  public function setJobUsage(?string $jobUsage);

  /**
   * Get the job's usage.
   */
  public function getJobUsage();

  /**
   * Get the job's tapis id.
   */
  public function getTapisId();

  /**
   * Set the job's tapis id.
   *
   * @param ?string $jobId
   *   The job ID.
   */
  public function setTapisId(?string $jobId);

  /**
   * Get the job's tapis uuid.
   */
  public function getTapisUUID();

  /**
   * Set the job's tapis uuid.
   *
   * @param ?string $jobUuid
   *   The job UUID.
   */
  public function setTapisUUID(?string $jobUuid);

  /**
   * Set the job's remote submitted timestamp.
   *
   * @param ?string $remoteSubmitted
   *   The remote submitted.
   */
  public function setRemoteSubmitted(?string $remoteSubmitted);

  /**
   * Set the job's remote started timestamp.
   *
   * @param ?string $remoteStarted
   *   The remote started.
   */
  public function setRemoteStarted(?string $remoteStarted);

  /**
   * Set the job's remote ended timestamp.
   *
   * @param ?string $remoteEnded
   *   The remote end.
   */
  public function setRemoteEnded(?string $remoteEnded);

  /**
   * Get the job's remote submitted timestamp.
   */
  public function getRemoteSubmitted();

  /**
   * Get the job's remote started timestamp.
   */
  public function getRemoteStarted();

  /**
   * Get the job's remote ended timestamp.
   */
  public function getRemoteEnded();

  /**
   * Get the job's webform submission id.
   */
  public function getWebformSubmissionId();

  /**
   * Get the job's app id.
   */
  public function getAppId();

  /**
   * Get the job's app.
   */
  public function getApp();

  /**
   * Get the job's system id.
   */
  public function getSystemId();

  /**
   * Get the job's system.
   */
  public function getSystem();

  /**
   * Get the job's tenant id.
   */
  public function getTenantId();

  /**
   * Get the job's tenant.
   */
  public function getTenant();

  /**
   * Get the job's proxy id.
   */
  public function getProxyId();

  /**
   * Set the job's custom resources.
   *
   * @param ?array $customJobResources
   *   The custom job resources.
   */
  public function setCustomJobResources(?array $customJobResources);

  /**
   * Set the original job that we are restarting for this current job.
   *
   * @param \Drupal\tapis_job\TapisJobInterface $originalJob
   *   The original job.
   */
  public function setOriginalJobForRestart(TapisJobInterface $originalJob);

  /**
   * Convert the job to a JSON object for use in the Tapis API.
   */
  public function toJSON();

}
