<?php

namespace Drupal\tapis_job\Entity\Routing;

use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\Core\Entity\Routing\AdminHtmlRouteProvider;

/**
 * Provides routes for Tapis Job entities.
 *
 * @see Drupal\Core\Entity\Routing\AdminHtmlRouteProvider
 *
 * This class is used to disable caching on the canonical route
 * for Tapis Job entities.
 * This is necessary because every time the page is refreshed,
 * we need to fetch its latest status from Tapis.
 */
class TapisJobRouteProvider extends AdminHtmlRouteProvider {

  /**
   * {@inheritdoc}
   */
  protected function getCanonicalRoute(EntityTypeInterface $entity_type) {
    // Disable caching on the canonical route.
    $route = parent::getCanonicalRoute($entity_type);
    $route->setOption('no_cache', TRUE);
    return $route;
  }

}
