<?php

namespace Drupal\tapis_job;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\EntityChangedInterface;
use Drupal\user\EntityOwnerInterface;

/**
 * Provides an interface defining a job access link entity type.
 */
interface JobAccessLinkInterface extends ContentEntityInterface, EntityOwnerInterface, EntityChangedInterface {

  /**
   * Get the job id.
   */
  public function getJobId();

  /**
   * Get the job for this access link.
   */
  public function getJob();

  /**
   * Set the proxy id for this access link.
   *
   * @param string $proxyId
   *   The proxy ID.
   */
  public function setProxyId($proxyId);

  /**
   * Get the proxy id for this access link.
   */
  public function getProxyId();

  /**
   * Get the proxy host for this access link.
   */
  public function getProxyHost();

  /**
   * Get the proxy url for this access link.
   */
  public function getProxyURL();

}
