<?php

namespace Drupal\tapis_job\Exception;

use Drupal\tapis_tenant\Exception\TapisException;

/**
 * Class TapisJobException.
 *
 * This class is used to throw exceptions specific to the Tapis Job module.
 *
 * @package Drupal\tapis_job\Exception
 */
class TapisJobException extends TapisException {

  /**
   * TapisJobException constructor.
   *
   * @param string $message
   *   The error message.
   * @param int $code
   *   The error code.
   * @param \Throwable|null $previous
   *   The previous message.
   */
  public function __construct($message, $code = 0, \Throwable $previous = NULL) {
    $message = "Tapis Job Exception: " . $message;
    parent::__construct($message, $code, $previous);
  }

}
