<?php

namespace Drupal\tapis_job\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\tapis_job\TapisJobInterface;

/**
 * Class JobShareForm.
 *
 * This class is used to create a form that allows a user to share a job
 * with another user.
 *
 * @package Drupal\tapis_job\Form
 */
class JobShareForm extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'tapis_job_share_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state, TapisJobInterface $tapis_job = NULL) {
    $form['#tree'] = TRUE;

    if (!$tapis_job) {
      return;
    }

    $form['share_user'] = [
      '#type' => 'entity_autocomplete',
      '#target_type' => 'user',
      '#selection_handler' => 'default',
    ];
    $form['save_button'] = [
      '#type' => 'submit',
      '#value' => t('Save access settings'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, FormStateInterface $form_state) {
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
  }

}
