# tapis_system

This module provides a Drupal integration for Tapis systems.

## Overview
This module adds support for Tapis systems within Drupal (https://tapis.readthedocs.io/en/latest/technical/systems.html).
In Tapis, systems refer to a combination of a user account & a server that can run compute jobs, store data, etc.
Using this module, Drupal users can now create & manage Tapis systems, system credentials, and batch system scheduler profiles within any Tapis site & tenant connected to the Drupal site.

Tapis systems and system scheduler profiles are represented as custom content types within Drupal, while system credentials are represented as custom entities.
This module also takes care of creating 2 views on the user's profile page: (1) to view all the systems that the user has access to, and (2) to view all the system credentials that the user has access to.

## How this module works
This module defines a custom content type called `Tapis System` that represents a Tapis system.
It also defines a custom content type called `Tapis System Scheduler Profile` that represents a Tapis system scheduler profile.
Finally, it defines a custom entity called `Tapis System Credential` that represents a Tapis system credential.
It also defines & exposes a `TapisSystemProvider` Drupal service that any module can use to perform Tapis system-level operations on behalf of users (e.g., creating a system, updating a system credential, etc.).

At the Tapis API layer, Tapis systems can be shared with the entire tenant, but at the Drupal site layer, fine-grained access control is enforced (using Node Casbin).
By decoupling the Tapis API layer's access control system from the Drupal site's access control system, we can provide a more flexible & secure access control system for Tapis systems.
This design is currently being used, since there is no straightforward way to constantly keep the Tapis API layer's access control system in sync with the Drupal site's access control system in a neat, reliable manner.
This may be subject to change in the future, if a better solution is found.

### System credentials
System credentials are basically a public/private key pair that can be used to access a system using a particular user account.
Note that the public key is also stored in the Drupal database, while the private key is NOT stored within Drupal (and is only securely stored within Tapis).

### Scheduler profiles
Scheduler profiles are a resource type in Tapis (similar to Systems, Apps, Jobs, etc.) that define the various `module` commands to run when launching a job (ex: `module purge`, `module load A`, etc.). Scheduler profiles can be assigned to jobs, apps, and systems, and when a job is submitted, Tapis will select the scheduler profile to use by picking the first one in that priority order.
