<?php

namespace Drupal\tapis_system;

/**
 * Define constants for Drupal's Tapis system.
 */
final class DrupalIds {
  const NODE_BUNDLE_SYSTEM = "tapis_system";
  const NODE_BUNDLE_SYSTEM_SCHEDULER_PROFILE = "tapis_system_scheduler_profile";

  const SYSTEM_BATCH_LOGICAL_QUEUES = 'tapis_sys_blqs';
  const SYSTEM_BATCH_SCHEDULER = 'tapis_sys_batch_scheduler';
  const SYSTEM_BATCH_SCHEDULER_PROFILE = 'tapis_sys_batch_sched_prof';
  const SYSTEM_BUCKET_NAME = 'tapis_sys_bucket_name';
  const SYSTEM_CAN_EXECUTE_JOBS = 'tapis_sys_can_exec';
  const SYSTEM_CAN_RUN_BATCH = 'tapis_sys_can_run_batch';

  const SYSTEM_LAUNCHER_PATH = 'tapis_sys_launcher_path';

  const SYSTEM_DEFAULT_BATCH_LOGICAL_QUEUE = 'tapis_sys_default_blq';
  const SYSTEM_DTN_MOUNT_POINT = 'tapis_sys_dtn_mount_point';
  const SYSTEM_DTN_MOUNT_SOURCE_PATH = 'tapis_sys_dtn_mount_source_path';
  const SYSTEM_DTN_SYSTEM = 'tapis_sys_dtn_system';
  const SYSTEM_EFFECTIVE_USER = 'tapis_sys_effective_user';
  const SYSTEM_ENABLED = 'tapis_sys_enabled';
  const SYSTEM_HOST = 'tapis_sys_host';
  const SYSTEM_IS_DTN = 'tapis_sys_is_dtn';
  const SYSTEM_JOB_CAPABILITIES = 'tapis_sys_job_capabilities';
  const SYSTEM_JOB_ENV_VARS = 'tapis_sys_job_env_vars';
  const SYSTEM_JOB_RUNTIMES = 'tapis_sys_job_runtimes';
  const SYSTEM_JOB_WORKING_DIR = 'tapis_sys_job_working_dir';
  const SYSTEM_LONG_DESCRIPTION = 'tapis_sys_description';
  const SYSTEM_MAX_NUM_OF_JOBS = 'tapis_sys_max_num_of_jobs';
  const SYSTEM_MAX_JOBS_PER_USER = 'tapis_sys_max_jobs_per_user';
  const SYSTEM_MPI_COMMAND = 'tapis_sys_mpi_command';
  const SYSTEM_OWNER = 'tapis_sys_owner';
  const SYSTEM_PORT = 'tapis_sys_port';
  const SYSTEM_PROXY_HOST = 'tapis_sys_proxy_host';
  const SYSTEM_PROXY_PORT = 'tapis_sys_proxy_port';
  const SYSTEM_ROOT_DIRECTORY = 'tapis_sys_root_directory';
  const SYSTEM_SHORT_DESCRIPTION = 'tapis_sys_short_description';
  const SYSTEM_TYPE = 'tapis_sys_system_type';
  const SYSTEM_TAGS = 'tapis_sys_tags';
  const SYSTEM_TAPIS_ID = 'tapis_sys_id';
  const SYSTEM_TENANT = 'tapis_sys_tenant';
  const SYSTEM_USE_PROXY = 'tapis_sys_use_proxy';
  const SYSTEM_USE_STATIC_SYSTEM_USER = 'tapis_sys_use_static_system_user';

  const SYSTEM_SCHEDULER_PROFILE_TAPIS_ID = "tapis_schedprof_name";
  const SYSTEM_SCHEDULER_PROFILE_TENANT = "tapis_schedprof_tenant";
  const SYSTEM_SCHEDULER_PROFILE_SUMMARY = "tapis_schedprof_summary";
  const SYSTEM_SCHEDULER_PROFILE_MODULE_COMMANDS = "tapis_schedprof_module_commands";

  const MODULE_COMMAND = "tapis_modloadcmd_module_command";
  const MODULE_COMMAND_MODULES = "tapis_modloadcmd_modules";

  // Const SYSTEM_SCHEDULER_PROFILE_MODS_TO_LOAD = "tapis_schedprof_modstoload";
  // const SYSTEM_SCHEDULER_PROFILE_MODULE_LOAD_CMD =
  // "tapis_schedprof_mod_load_cmd";.
  const SYSTEM_SCHEDULER_PROFILE_HIDDEN_OPTIONS = "tapis_schedprof_hidden_opts";

  const SYSTEM_BLQ_HPC_QUEUE_NAME = "tapis_blq_hpc_queue_name";
  const SYSTEM_BLQ_MAX_CORES_PER_NODE = "tapis_blq_max_cores_per_node";
  const SYSTEM_BLQ_MAX_MEMORY = "tapis_blq_max_memory_mb";
  const SYSTEM_BLQ_MAX_JOBS = "tapis_blq_max_jobs";
  const SYSTEM_BLQ_MAX_JOBS_PER_USER = "tapis_blq_max_jobs_peruser";
  const SYSTEM_BLQ_MAX_NODES = "tapis_blq_maxnodecount";
  const SYSTEM_BLQ_MAX_TIME = "tapis_blq_maxminutes";
  const SYSTEM_BLQ_MIN_CORES_PER_NODE = "tapis_blq_mincorespernode";
  const SYSTEM_BLQ_MIN_MEMORY = "tapis_blq_minmemorymb";
  const SYSTEM_BLQ_MIN_NODES = "tapis_blq_minnodecount";
  const SYSTEM_BLQ_MIN_TIME = "tapis_blq_minminutes";

  const SYSTEM_JOB_CAPABILITY_CATEGORY = "tapis_job_capability_category";
  const SYSTEM_JOB_CAPABILITY_DATA_TYPE = "tapis_job_capability_datatype";
  const SYSTEM_JOB_CAPABILITY_PRECEDENCE = "tapis_job_capability_precedence";
  const SYSTEM_JOB_CAPABILITY_VALUE = "tapis_job_capability_value";

  const SYSTEM_NOTES = "tapis_sys_notes";
}
