<?php

namespace Drupal\tapis_system\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\tapis_system\TapisSystemCredentialInterface;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;

/**
 * Class TapisSystemCredentialDownload.
 *
 * This controller is responsible for downloading the public key.
 *
 * @package Drupal\tapis_system\Controller
 */
class TapisSystemCredentialDownload extends ControllerBase {

  /**
   * Download the public key for a Tapis System Credential.
   *
   * @param \Drupal\tapis_system\TapisSystemCredentialInterface $tapis_system_credential
   *   Tapis system credential interface.
   */
  public function downloadCredentials(TapisSystemCredentialInterface $tapis_system_credential) {
    // If the current user is NOT the owner of the credential,
    // throw a not found exception.
    if ($this->currentUser()->id() !== $tapis_system_credential->getOwnerId()) {
      throw new NotFoundHttpException();
    }

    $public_key = $tapis_system_credential->getPublicKey();

    if (!$public_key) {
      throw new NotFoundHttpException();
    }

    // Set the headers for the file download.
    $headers = [
      'Content-Type' => 'application/x-pem-file',
      'Content-Disposition' => 'attachment; filename="tapis_ssh.pub"',
    ];

    // Trigger the file download.
    $response = new Response();
    $response->headers->add($headers);
    $response->setContent($public_key);

    return $response;
  }

}
