<?php

namespace Drupal\tapis_system\Exception;

use Drupal\tapis_tenant\Exception\TapisException;

/**
 * Class TapisSystemException.
 *
 * Exception class for Tapis System module.
 */
class TapisSystemException extends TapisException {

  /**
   * TapisSystemException constructor.
   *
   * @param string $message
   *   The error message.
   * @param int $code
   *   The error code.
   * @param \Throwable|null $previous
   *   The previous message.
   */
  public function __construct($message, $code = 0, \Throwable $previous = NULL) {
    $message = "Tapis System Exception: " . $message;
    parent::__construct($message, $code, $previous);
  }

}
