<?php

namespace Drupal\tapis_system;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Entity\EntityAccessControlHandler;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Session\AccountInterface;

/**
 * Defines the access control handler for the system credential entity type.
 */
class TapisSystemCredentialAccessControlHandler extends EntityAccessControlHandler {

  /**
   * {@inheritdoc}
   */
  protected function checkAccess(EntityInterface $entity, $operation, AccountInterface $account) {

    /** @var \Drupal\tapis_system\Entity\TapisSystemCredential $entity */
    switch ($operation) {
      case 'view':
        if ($entity->getOwnerId() === $account->id() && $account->hasPermission('view own system credential')) {
          return AccessResult::allowed();
        }
        return AccessResult::allowedIfHasPermissions(
          $account,
          ['administer tapis system', 'edit any tapis_system content'],
          'OR',
        );

      case 'update':
        if ($entity->getOwnerId() === $account->id() && $account->hasPermission('edit own system credential')) {
          return AccessResult::allowed();
        }
        return AccessResult::allowedIfHasPermissions(
          $account,
          ['administer tapis system', 'edit any tapis_system content'],
          'OR',
        );

      case 'delete':
        if ($entity->getOwnerId() === $account->id() && $account->hasPermission('delete own system credential')) {
          return AccessResult::allowed();
        }
        return AccessResult::allowedIfHasPermissions(
          $account,
          ['administer tapis system', 'delete any tapis_system content'],
          'OR',
        );

      default:
        // No opinion.
        return AccessResult::neutral();
    }

  }

  /**
   * {@inheritdoc}
   */
  protected function checkCreateAccess(AccountInterface $account, array $context, $entity_bundle = NULL) {
    return AccessResult::allowedIfHasPermissions(
      $account,
      ['create system credential', 'administer tapis system', 'edit any tapis_system content'],
      'OR',
    );
  }

}
