<?php

namespace Drupal\tapis_system;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\EntityChangedInterface;
use Drupal\user\EntityOwnerInterface;

/**
 * Provides an interface defining a system credential entity type.
 */
interface TapisSystemCredentialInterface extends ContentEntityInterface, EntityOwnerInterface, EntityChangedInterface {

  /**
   * Get the Tapis definition for this system credential.
   */
  public function getTapisDefinition();

  /**
   * Set the Tapis definition for this system credential.
   *
   * @param array $definition
   *   The Tapis definition.
   */
  public function setTapisDefinition(array $definition);

  /**
   * Get this credential's system id.
   */
  public function getSystemId();

  /**
   * Set the public key for this system credential.
   *
   * @param string $publicKey
   *   The public key.
   */
  public function setPublicKey($publicKey);

  /**
   * Get this credential's public key.
   */
  public function getPublicKey();

}
